<?php
$jsonData = file_get_contents('php://input');
$data = json_decode($jsonData, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    echo "Gagal mengurai JSON. Error: " . json_last_error_msg();
    exit;
}

$requiredFields = ['origin', 'date_done', 'creation_date', 'branch_name', 'schedule_date', 'customer_name', 'branch_id', 'name', 'state', 'customer_id', 'pack_operation_product_ids'];
$missingFields = array_filter($requiredFields, function ($field) use ($data) {
    return empty($data[$field]);
});

if (!empty($missingFields)) {
    echo "Kolom-kolom berikut harus diisi: " . implode(', ', $missingFields);
} else {
    include './config.php';
    
    $id_out = $data['id'];

    // Pemeriksaan apakah data sudah ada
    $checkStmt = $conn->prepare("SELECT id FROM outgoing_data WHERE id = ?");
    $checkStmt->bind_param("i", $id_out);
    $checkStmt->execute();
    $checkStmt->store_result();
    
    if ($checkStmt->num_rows > 0) {
        // Data sudah ada
        echo "Data sudah ada.";
    } else {
        // Data belum ada, simpan data ke tabel pertama
        $stmt1 = $conn->prepare("INSERT INTO outgoing_data (id, origin, date_done, creation_date, branch_name, schedule_date, customer_name, branch_id, name, note, state, customer_id) VALUES (?,?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt1->bind_param("issssssisssi", $id_out, $data['origin'], $data['date_done'], $data['creation_date'], $data['branch_name'], $data['schedule_date'], $data['customer_name'], $data['branch_id'], $data['name'], $data['note'], $data['state'], $data['customer_id']);

        if ($stmt1->execute()) {
            // Simpan data kedua ke tabel kedua (pack_operation_product)
            foreach ($data['pack_operation_product_ids'] as $pack_operation) {
                $description_picking = $pack_operation['description_picking'];
                $product_qty = $pack_operation['product_qty'];
                $location_id = $pack_operation['location_id'];
                $quantity_done = $pack_operation['quantity_done'];
                $location_name = $pack_operation['location_name'];
                $product_id = $pack_operation['product_id'];
                $product_uom_id = $pack_operation['product_uom_id'];
                $location_dest_id = $pack_operation['location_dest_id'];
                $ordered_qty = $pack_operation['ordered_qty'];
                $product_uom_name = $pack_operation['product_uom_name'];
                $product_name = $pack_operation['product_name'];
                $id_pack = $pack_operation['id'];

                $stmt2 = $conn->prepare("INSERT INTO pack_operation_product (id, description_picking, product_qty, location_id, quantity_done, location_name, product_id, product_uom_id, location_dest_id, ordered_qty, product_uom_name, product_name, picking_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                $stmt2->bind_param("isdiississssi", $id_pack, $description_picking, $product_qty, $location_id, $quantity_done, $location_name, $product_id, $product_uom_id, $location_dest_id, $ordered_qty, $product_uom_name, $product_name, $id_out);

                if ($stmt2->execute()) {
                    echo "Data berhasil disimpan di tabel kedua.";
                } else {
                    echo "Error di tabel kedua: " . $stmt2->error;
                }
            }
        } else {
            echo "Error di tabel pertama: " . $stmt1->error;
        }

        $stmt1->close();
        $stmt2->close();
    }
    
    $checkStmt->close();
    $conn->close();
}
?>
