<?php
include './config.php';

// Query untuk mengambil data outgoing_data
$query_outgoing = "SELECT id, origin, date_done, creation_date, branch_name, schedule_date, customer_name, branch_id, name, note, state, customer_id FROM outgoing_data WHERE branch_id = 1";
$result_outgoing = $conn->query($query_outgoing);

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <title>Data Outgoing dan Pack Operation Product</title>
</head>
<body>

<div class="container-fluid mt-5">
    
    <h2>Data Outgoing dan Pack Operation Product</h2>

    <?php
    // Tampilkan data outgoing_data dalam tabel
    if ($result_outgoing->num_rows > 0) {
        while ($row_outgoing = $result_outgoing->fetch_assoc()) {
            ?>
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title">Outgoing Data - ID <?php echo $row_outgoing["id"]; ?></h5>
                </div>
                <div class="card-body">
                    <table class="table">
                        <thead>
                        <tr>
                            <th>ID</th>
                            <th>Origin</th>
                            <th>Date Done</th>
                            <th>Creation Date</th>
                            <th>Branch Name</th>
                            <th>Schedule Date</th>
                            <th>Customer Name</th>
                            <th>Branch ID</th>
                            <th>Name</th>
                            <th>Note</th>
                            <th>State</th>
                            <th>Customer ID</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td><?php echo $row_outgoing["id"]; ?></td>
                            <td><?php echo $row_outgoing["origin"]; ?></td>
                            <td><?php echo $row_outgoing["date_done"]; ?></td>
                            <td><?php echo $row_outgoing["creation_date"]; ?></td>
                            <td><?php echo $row_outgoing["branch_name"]; ?></td>
                            <td><?php echo $row_outgoing["schedule_date"]; ?></td>
                            <td><?php echo $row_outgoing["customer_name"]; ?></td>
                            <td><?php echo $row_outgoing["branch_id"]; ?></td>
                            <td><?php echo $row_outgoing["name"]; ?></td>
                            <td><?php echo $row_outgoing["note"]; ?></td>
                            <td><?php echo $row_outgoing["state"]; ?></td>
                            <td><?php echo $row_outgoing["customer_id"]; ?></td>
                        </tr>
                        </tbody>
                    </table>

                    <?php
                    // Query untuk mengambil data pack_operation_product yang memiliki id yang sama dengan id pada outgoing_data
                    $query_pack = "SELECT id, description_picking, product_qty, location_id, quantity_done, location_name, product_id, product_uom_id, location_dest_id, ordered_qty, product_uom_name, product_name, picking_id, stock_quant_id FROM pack_operation_product WHERE picking_id = " . $row_outgoing["id"];
                    $result_pack = $conn->query($query_pack);

                    // Tampilkan data pack_operation_product dalam sub-table
                    ?>
                    <table class="table ml-4">
                        <thead>
                        <tr>
                            <th>ID</th>
                            <th>Description Picking</th>
                            <th>Product Qty</th>
                            <th>Location ID</th>
                            <th>Quantity Done</th>
                            <th>Location Name</th>
                            <th>Product ID</th>
                            <th>Product UOM ID</th>
                            <th>Location Dest ID</th>
                            <th>Ordered Qty</th>
                            <th>Product UOM Name</th>
                            <th>Product Name</th>
                            <th>Picking ID</th>
                            <th>Stock ID</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        if ($result_pack->num_rows > 0) {
                            while ($row_pack = $result_pack->fetch_assoc()) {
                                ?>
                                <tr>
                                    <td><?php echo $row_pack["id"]; ?></td>
                                    <td><?php echo $row_pack["description_picking"]; ?></td>
                                    <td><?php echo $row_pack["product_qty"]; ?></td>
                                    <td><?php echo $row_pack["location_id"]; ?></td>
                                    <td><?php echo $row_pack["quantity_done"]; ?></td>
                                    <td><?php echo $row_pack["location_name"]; ?></td>
                                    <td><?php echo $row_pack["product_id"]; ?></td>
                                    <td><?php echo $row_pack["product_uom_id"]; ?></td>
                                    <td><?php echo $row_pack["location_dest_id"]; ?></td>
                                    <td><?php echo $row_pack["ordered_qty"]; ?></td>
                                    <td><?php echo $row_pack["product_uom_name"]; ?></td>
                                    <td><?php echo $row_pack["product_name"]; ?></td>
                                    <td><?php echo $row_pack["picking_id"]; ?></td>
                                    <td><?php echo $row_pack["stock_quant_id"]; ?></td>
                                </tr>
                                <?php
                            }
                        } else {
                            echo "<tr><td colspan='13'>Tidak ada data pack_operation_product</td></tr>";
                        }
                        ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php
        }
    } else {
        echo "<p class='alert alert-warning'>Tidak ada data outgoing_data</p>";
    }
    ?>

</div>

<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

</body>
</html>

<?php
// Tutup koneksi
$conn->close();
?>
