<?php
//receive_data.php

header('Content-Type: application/json');

$receivedToken = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
$sharedSecretToken = '6b2049d42314d6c3dbc8a44cc23d61b9d5158455d0039123f4f0e033a7bc3733';

// Validasi token
if ($receivedToken !== 'Bearer ' . $sharedSecretToken) {
    http_response_code(401);
    echo json_encode(['message' => 'Token tidak valid. Akses ditolak.']);
    exit;
}

$jsonData = file_get_contents('php://input');
$data = json_decode($jsonData, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(['message' => 'Gagal mengurai JSON: ' . json_last_error_msg()]);
    exit;
}

// ---- LOGIKA UTAMA ----
include './config.php';

$is_edit = isset($data['is_edit']) && $data['is_edit'] === true;

// ## PERUBAHAN 1: Validasi dinamis
// Field yang wajib ada untuk semua kondisi
$requiredFields = ['origin', 'date_done', 'creation_date', 'branch_name', 'schedule_date', 'customer_name', 'branch_id', 'name', 'state', 'customer_id', 'pack_operation_product_ids'];

$missingFields = array_filter($requiredFields, fn($field) => !isset($data[$field]));

if (!empty($missingFields)) {
    http_response_code(400);
    echo json_encode(['message' => 'Kolom berikut harus diisi: ' . implode(', ', $missingFields)]);
    exit;
}

// Memulai transaksi untuk menjaga integritas data
$conn->begin_transaction();

try {
    if ($is_edit) {
        // =================================================
        // ## PERUBAHAN 2: LOGIKA UPDATE DATA BERDASARKAN 'name' (NOMOR INVOICE)
        // =================================================

        // 1. Ambil nomor invoice dari payload.
        $invoice_number = $data['name'];
        $id_out = null;

        // 2. Cari 'id' internal berdasarkan 'name' yang unik.
        // 'id' tetap dibutuhkan untuk mengelola relasi di tabel 'pack_operation_product'.
        $stmt_find = $conn->prepare("SELECT id FROM outgoing_data WHERE name = ?");
        $stmt_find->bind_param("s", $invoice_number);
        $stmt_find->execute();
        $result = $stmt_find->get_result();

        if ($row = $result->fetch_assoc()) {
            $id_out = $row['id'];
        }
        $stmt_find->close();

        // Jika data dengan 'name' tersebut tidak ditemukan, kirim error.
        if ($id_out === null) {
            http_response_code(404); // 404 Not Found
            echo json_encode(['message' => "Data dengan nomor invoice '$invoice_number' tidak ditemukan."]);
            $conn->rollback();
            exit;
        }

        // 3. Update tabel utama (outgoing_data) menggunakan 'name' sebagai kunci di WHERE clause.
        $stmt_update_main = $conn->prepare(
            "UPDATE outgoing_data SET 
                origin = ?, date_done = ?, creation_date = ?, branch_name = ?, schedule_date = ?, 
                customer_name = ?, branch_id = ?, note = ?, state = ?, customer_id = ?
            WHERE name = ?" // <-- Menggunakan 'name' sebagai kondisi
        );
        // Sesuaikan bind_param: 10 kolom SET + 1 kolom WHERE
        $stmt_update_main->bind_param(
            "ssssssisssi", // 11 tipe data, 's' terakhir untuk 'name'
            $data['origin'], $data['date_done'], $data['creation_date'], $data['branch_name'], 
            $data['schedule_date'], $data['customer_name'], $data['branch_id'], 
            $data['note'], $data['state'], $data['customer_id'],
            $invoice_number // Variabel untuk WHERE name = ?
        );
        $stmt_update_main->execute();
        $stmt_update_main->close();

        // 4. Hapus item lama di tabel relasi menggunakan 'id' yang sudah kita dapatkan.
        $stmt_delete_items = $conn->prepare("DELETE FROM pack_operation_product WHERE picking_id = ?");
        $stmt_delete_items->bind_param("i", $id_out);
        $stmt_delete_items->execute();
        $stmt_delete_items->close();

        // 5. Masukkan kembali item-item baru dengan 'id' yang sama.
        foreach ($data['pack_operation_product_ids'] as $item) {
            insert_pack_operation($conn, $item, $id_out);
        }
        
        echo json_encode(['message' => "Data dengan nomor invoice '$invoice_number' berhasil diperbarui."]);

    } else {
        // =================================================
        // ## PERUBAHAN 3: LOGIKA INSERT DATA BARU (TANPA MENGIRIM ID)
        // =================================================

        // Cek duplikasi berdasarkan 'name' (nomor invoice) sebelum insert
        $checkStmt = $conn->prepare("SELECT id FROM outgoing_data WHERE name = ?");
        $checkStmt->bind_param("s", $data['name']);
        $checkStmt->execute();
        $checkStmt->store_result();

        if ($checkStmt->num_rows > 0) {
            http_response_code(409); // 409 Conflict
            echo json_encode(['message' => "Data dengan nomor invoice '" . $data['name'] . "' sudah ada."]);
        } else {
            // 1. Insert ke tabel utama (outgoing_data) tanpa menyertakan kolom 'id'.
            // Biarkan database mengisinya dengan AUTO_INCREMENT.
            $stmt1 = $conn->prepare(
                "INSERT INTO outgoing_data (origin, date_done, creation_date, branch_name, schedule_date, customer_name, branch_id, name, note, state, customer_id) 
                 VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"
            );
            $stmt1->bind_param(
                "ssssssisssi", // 11 tipe data, tanpa 'i' untuk id
                $data['origin'], $data['date_done'], $data['creation_date'], $data['branch_name'], 
                $data['schedule_date'], $data['customer_name'], $data['branch_id'], $data['name'], 
                $data['note'], $data['state'], $data['customer_id']
            );
            $stmt1->execute();

            // Ambil ID yang baru saja dibuat oleh database
            $new_id_out = $conn->insert_id;
            $stmt1->close();
            
            // 2. Insert item-item ke tabel relasi menggunakan ID baru tersebut.
            foreach ($data['pack_operation_product_ids'] as $item) {
                insert_pack_operation($conn, $item, $new_id_out);
            }
            
            http_response_code(201); // 201 Created
            echo json_encode(['message' => "Data berhasil disimpan dengan ID baru: $new_id_out."]);
        }
        $checkStmt->close();
    }

    // Jika semua query berhasil, simpan perubahan
    $conn->commit();

} catch (Exception $e) {
    // Jika ada error, batalkan semua perubahan
    $conn->rollback();
    http_response_code(500);
    echo json_encode(['message' => 'Terjadi kesalahan pada server: ' . $e->getMessage()]);
}

$conn->close();


/**
 * Fungsi untuk memasukkan data ke tabel pack_operation_product.
 * Dibuat menjadi fungsi agar bisa digunakan ulang untuk proses INSERT dan UPDATE.
 *
 * @param mysqli $conn Koneksi database
 * @param array $item Satu item dari pack_operation_product_ids
 * @param int $picking_id ID dari data utama (outgoing_data)
 */
function insert_pack_operation($conn, $item, $picking_id) {
    // ... (Fungsi ini tidak perlu diubah, sudah benar) ...
    $stock_quant_id = null;
    $product_code = $item['product_code'] ?? null;
    $location_id = $item['location_id'] ?? null;

    if ($product_code && $location_id) {
        $stock_quant_query = "SELECT id FROM product_stock_by_location WHERE product_code = ? AND location_id = ?";
        $stock_quant_stmt = $conn->prepare($stock_quant_query);
        $stock_quant_stmt->bind_param('si', $product_code, $location_id);
        $stock_quant_stmt->execute();
        $stock_quant_stmt->store_result();
        
        if ($stock_quant_stmt->num_rows > 0) {
            $stock_quant_stmt->bind_result($fetched_id);
            $stock_quant_stmt->fetch();
            $stock_quant_id = $fetched_id;
        }
        $stock_quant_stmt->close();
    }

    $query = "INSERT INTO pack_operation_product 
              (id, description_picking, product_qty, location_id, quantity_done, location_name, 
              product_id, product_code, product_uom_id, location_dest_id, ordered_qty, 
              product_uom_name, product_name, picking_id, stock_quant_id) 
              VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($query);

    $types = "isdidsisiidssii";
    
    if ($stock_quant_id === null) {
        $types = "isdidsisiidssis";
    }

    $stmt->bind_param(
        $types,
        $item['id'],
        $item['description_picking'],
        $item['product_qty'],
        $item['location_id'],
        $item['quantity_done'],
        $item['location_name'],
        $item['product_id'],
        $item['product_code'],
        $item['product_uom_id'],
        $item['location_dest_id'],
        $item['ordered_qty'],
        $item['product_uom_name'],
        $item['product_name'],
        $picking_id,
        $stock_quant_id
    );

    $stmt->execute();
    if ($stmt->error) {
        throw new Exception("Gagal memasukkan item: " . $stmt->error);
    }
    $stmt->close();
}
?>