<?php
include './config.php';

function fetchData($url, $body) {
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));

    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response);
}

// URL and body for the API
$url = "http://47.101.157.32:8507/odoo-api/do_search_1k";

date_default_timezone_set('Asia/Jakarta');
$current_date = date('Y-m-d');

$body = '{
    "jsonrpc": "2.0",
    "params": {
        "db": "hongyi_live_2019",
        "login": "user_api",
        "password": "user_api",
        "filters": [["picking_type_code", "=", "outgoing"],["min_date", ">=", "2023-11-01 00:00:01"],["min_date", "<=", "2023-11-30 23:59:59"],["state", "not in", ["cancel","draft"]]]
    }
}';

$data = fetchData($url, $body);

// Initialize variable to count newly inserted data
$countNewlyInsertedData = 0;

foreach ($data->result as $item) {
    // Check if branch_id is 1
    if ($item->branch_id == 1) {
        // Check if 'id' and 'name' already exist in the outgoing_data table
        $check_data_query = "SELECT id FROM outgoing_data WHERE id = ? AND name = ?";
        $check_data_stmt = $conn->prepare($check_data_query);
        $check_data_stmt->bind_param('is', $item->id, $item->name);
        $check_data_stmt->execute();
        $check_data_stmt->store_result();

        if ($check_data_stmt->num_rows == 0) {
            $countNewlyInsertedData++;

            // Insert data into the MySQL table
            $id = $item->id;
            $origin = $item->origin;
            $date_done = $item->date_done;
            $creation_date = $item->creation_date;
            $branch_name = $item->branch_name;
            $schedule_date = $item->schedule_date;
            $customer_name = $item->customer_name;
            $branch_id = $item->branch_id;
            $name = $item->name;
            $note = $item->note;
            $state = $item->state;
            $customer_id = $item->customer_id;

            // Check if 'name' already exists in the outgoing_data table
            $check_name_query = "SELECT name FROM outgoing_data WHERE name = ?";
            $check_name_stmt = $conn->prepare($check_name_query);
            $check_name_stmt->bind_param('s', $name);
            $check_name_stmt->execute();
            $check_name_stmt->store_result();

            if ($check_name_stmt->num_rows == 0) {
                // Query to insert data into the MySQL table
                $query = "INSERT INTO outgoing_data (id, origin, date_done, creation_date, branch_name, schedule_date, customer_name, branch_id, name, note, state, customer_id) 
                          VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

                // Prepare statement
                $stmt = $conn->prepare($query);
                // Bind parameters
                $stmt->bind_param('issssssissis', $id, $origin, $date_done, $creation_date, $branch_name, $schedule_date, $customer_name, $branch_id, $name, $note, $state, $customer_id);
                // Execute statement
                $stmt->execute();

                // Fetch and store data from pack_operation_product_ids
                foreach ($item->pack_operation_product_ids as $pack_operation) {
                    $pack_operation_id = $pack_operation->id;
                    $description_picking = $pack_operation->description_picking;
                    $product_qty = $pack_operation->product_qty;
                    $location_id = $pack_operation->location_id;
                    $quantity_done = $pack_operation->quantity_done;
                    $location_name = $pack_operation->location_name;
                    $product_id = $pack_operation->product_id;
                    $product_uom_id = $pack_operation->product_uom_id;
                    $location_dest_id = $pack_operation->location_dest_id;
                    $ordered_qty = $pack_operation->ordered_qty;
                    $product_uom_name = $pack_operation->product_uom_name;
                    $product_name = $pack_operation->product_name;

                    // Get id from the product_stock_by_location table if product_id is the same
                    $stock_quant_query = "SELECT id FROM product_stock_by_location WHERE product_id = ? AND location_id = ?";
                    $stock_quant_stmt = $conn->prepare($stock_quant_query);
                    $stock_quant_stmt->bind_param('ii', $product_id, $location_id);
                    $stock_quant_stmt->execute();
                    $stock_quant_stmt->store_result();
                    $stock_quant_id = null;

                    if ($stock_quant_stmt->num_rows > 0) {
                        $stock_quant_stmt->bind_result($fetched_stock_quant_id);
                        $stock_quant_stmt->fetch();
                        $stock_quant_id = $fetched_stock_quant_id;
                    }

                    // Query to insert data into the pack_operation_product table
                    $query = "INSERT INTO pack_operation_product (id, description_picking, product_qty, location_id, quantity_done, location_name, product_id, product_uom_id, location_dest_id, ordered_qty, product_uom_name, product_name, picking_id, stock_quant_id) 
                              VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

                    // Prepare statement
                    $stmt = $conn->prepare($query);
                    // Bind parameters
                    $stmt->bind_param('isdiisiiisdsii', $pack_operation_id, $description_picking, $product_qty, $location_id, $quantity_done, $location_name, $product_id, $product_uom_id, $location_dest_id, $ordered_qty, $product_uom_name, $product_name, $id, $stock_quant_id);
                    // Execute statement
                    $stmt->execute();
                }
            }
        }
    }
}

echo "Number of newly inserted data: $countNewlyInsertedData\n";
echo "Data successfully saved to the MySQL table.\n";
?>
